package org.eclipse.swt.widgets;

/*
 * Copyright (c) 2000, 2002 IBM Corp.  All rights reserved.
 * This file is made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */

import org.eclipse.swt.internal.pm.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

/**
 * Instances of the receiver represent is an unselectable
 * user interface object that is used to display progress,
 * typically in the form of a bar.
 * <dl>
 * <dt><b>Styles:</b></dt>
 * <dd>SMOOTH, HORIZONTAL, VERTICAL</dd>
 * <dt><b>Events:</b></dt>
 * <dd>(none)</dd>
 * </dl>
 * <p>
 * Note: Only one of the styles HORIZONTAL and VERTICAL may be specified.
 * </p><p>
 * IMPORTANT: This class is intended to be subclassed <em>only</em>
 * within the SWT implementation.
 * </p>
 */
public class ProgressBar extends Control {
        int maxRange;
        int minRange;
        int position;
//	static final int ProgressBarProc;
//	static final TCHAR ProgressBarClass = new TCHAR (0, OS.PROGRESS_CLASS, true);
//	static {
//		WNDCLASS lpWndClass = new WNDCLASS ();
//		OS.GetClassInfo (0, ProgressBarClass, lpWndClass);
//		ProgressBarProc = lpWndClass.lpfnWndProc;
//	}
//
///**
// * Constructs a new instance of this class given its parent
// * and a style value describing its behavior and appearance.
// * <p>
// * The style value is either one of the style constants defined in
// * class <code>SWT</code> which is applicable to instances of this
// * class, or must be built by <em>bitwise OR</em>'ing together
// * (that is, using the <code>int</code> "|" operator) two or more
// * of those <code>SWT</code> style constants. The class description
// * lists the style constants that are applicable to the class.
// * Style bits are also inherited from superclasses.
// * </p>
// *
// * @param parent a composite control which will be the parent of the new instance (cannot be null)
// * @param style the style of control to construct
// *
// * @exception IllegalArgumentException <ul>
// *    <li>ERROR_NULL_ARGUMENT - if the parent is null</li>
// * </ul>
// * @exception SWTException <ul>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the parent</li>
// *    <li>ERROR_INVALID_SUBCLASS - if this class is not an allowed subclass</li>
// * </ul>
// *
// * @see SWT#SMOOTH
// * @see SWT#HORIZONTAL
// * @see SWT#VERTICAL
// * @see Widget#checkSubclass
// * @see Widget#getStyle
// */
public ProgressBar (Composite parent, int style) {
//	super (parent, checkStyle (style));
        PSZ pszTitle = new PSZ("u");
        PSZ pszButton1 = new PSZ("Text 2");
        PSZ pszCaption1 = new PSZ("Text 3");
        PSZ pszCaption2 = new PSZ("Text 4");
        PSZ pszCaption3 = new PSZ("Text 5");
        PSZ pszFontNameSize = new PSZ("9.WarpSans Bold");
        if ((handle=OS.PrgShowDlg(OS.HWND_DESKTOP, parent.handle, (short)(OS.PRS_SHOW | OS.PRS_BAR | OS.PRS_SEGMENTED), -1,0, 0, (short)1234, null, null, null, null, null)) != OS.NULLHANDLE){        
            int[] pulForegroundColor = new int[1];
            int[] pulBackgroundColor = new int[1];
            pulForegroundColor[0] = OS.LEAVE_AS_IS;
            pulBackgroundColor[0] = OS.LEAVE_AS_IS;
//            if(!OS.PrgSetupAttributes(handle, OS.CAPTION_SET_1, pulForegroundColor, pulBackgroundColor, pszFontNameSize, true))
//                System.out.println("Couldn't create progress dialog! ");
        }
        else{
            System.out.println("Couldn't create progress dialog! ");
        }
}

int callWindowProc (int msg, int mp1, int mp2) {
	/* if (handle == 0)  */return 0;
//	return OS.CallWindowProc (ProgressBarProc, handle, msg, wParam, lParam);
}

static int checkStyle (int style) {
	return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
}

//public Point computeSize (int wHint, int hHint, boolean changed) {
//	checkWidget ();
//	int border = getBorderWidth ();
//	int width = border * 2, height = border * 2;
//	if ((style & SWT.HORIZONTAL) != 0) {
//		width += OS.GetSystemMetrics (OS.SM_CXHSCROLL) * 10;
//		height += OS.GetSystemMetrics (OS.SM_CYHSCROLL);
//	} else {
//		width += OS.GetSystemMetrics (OS.SM_CXVSCROLL);
//		height += OS.GetSystemMetrics (OS.SM_CYVSCROLL) * 10;
//	}
//	if (wHint != SWT.DEFAULT) width = wHint + (border * 2);
//	if (hHint != SWT.DEFAULT) height = hHint + (border * 2);
//	return new Point (width, height);
//}

void createHandle () {
	super.createHandle ();
//	OS.SendMessage (handle, OS.TBM_SETRANGEMAX, 0, 100);
//	OS.SendMessage (handle, OS.TBM_SETPAGESIZE, 0, 10);
//	OS.SendMessage (handle, OS.TBM_SETTICFREQ, 10, 0);
}

//int defaultForeground () {
//	return OS.GetSysColor (OS.COLOR_HIGHLIGHT);
//}
//
///**
// * Returns the maximum value which the receiver will allow.
// *
// * @return the maximum
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public int getMaximum () {
	checkWidget ();
	return maxRange;
}

///**
// * Returns the minimum value which the receiver will allow.
// *
// * @return the minimum
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public int getMinimum () {
	checkWidget ();
	return minRange;
}

///**
// * Returns the single <em>selection</em> that is the receiver's position.
// *
// * @return the selection
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public int getSelection () {
	checkWidget ();
	return position;
}

//void setBackgroundPixel (int pixel) {
//	if (background == pixel) return;
//	background = pixel;
//	/*
//	* Feature in Windows.  Setting the color to be
//	* the current default is not correct because the
//	* widget will not change colors when the colors
//	* are changed from the control panel.  There is
//	* no fix at this time.
//	*/
//	if (pixel == -1) pixel = defaultBackground ();
//	OS.SendMessage (handle, OS.PBM_SETBKCOLOR, 0, pixel);
//}

public boolean setFocus () {
	checkWidget();
	return false;
}

//void setForegroundPixel (int pixel) {
//	if (foreground == pixel) return;
//	foreground = pixel;
//	/*
//	* Feature in Windows.  Setting the color to be
//	* the current default is not correct because the
//	* widget will not change colors when the colors
//	* are changed from the control panel.  There is
//	* no fix at this time.
//	*/
//	if (pixel == -1) pixel = defaultForeground ();
//	OS.SendMessage (handle, OS.PBM_SETBARCOLOR, 0, pixel);
//}
//
///**
// * Sets the maximum value which the receiver will allow
// * to be the argument which must be greater than or
// * equal to zero.
// *
// * @param value the new maximum (must be zero or greater)
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public void setMaximum (int value) {
	checkWidget ();
	if (0 <= minRange && minRange < value) {
		maxRange = value;
	}
}

///**
// * Sets the minimum value which the receiver will allow
// * to be the argument which must be greater than or
// * equal to zero.
// *
// * @param value the new minimum (must be zero or greater)
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public void setMinimum (int value) {
	checkWidget ();
	if (0 <= value && value < maxRange) {
		minRange = value;
	}
}

///**
// * Sets the single <em>selection</em> that is the receiver's
// * position to the argument which must be greater than or equal
// * to zero.
// *
// * @param value the new selection (must be zero or greater)
// *
// * @exception SWTException <ul>
// *    <li>ERROR_WIDGET_DISPOSED - if the receiver has been disposed</li>
// *    <li>ERROR_THREAD_INVALID_ACCESS - if not called from the thread that created the receiver</li>
// * </ul>
// */
public void setSelection (int value) {
	checkWidget ();
	if (value < 0) return;
        position = value;
	int percent = (value*(maxRange-minRange))/100;
        OS.PrgSetPercentage(handle, (short)percent);
}

int widgetStyle () {
	int bits = super.widgetStyle ();
//	if ((style & SWT.SMOOTH) != 0) bits |= OS.PBS_SMOOTH;
//	if ((style & SWT.VERTICAL) != 0) bits |= OS.PBS_VERTICAL;
	return bits;
}

PSZ windowClass () {
	return null;
}

int windowProc () {
	return 0;
}
//
//LRESULT WM_GETDLGCODE (int wParam, int lParam) {
//	LRESULT result = super.WM_GETDLGCODE (wParam, lParam);
//	if (result != null) return result;
//	/*
//	* Feature in Windows.  The progress bar does
//	* not implement WM_GETDLGCODE.  As a result,
//	* a progress bar takes focus and takes part
//	* in tab traversal.  This behavior, while
//	* unspecified, is unwanted.  The fix is to
//	* implement WM_GETDLGCODE to behave like a
//	* STATIC control.
//	*/
//	return new LRESULT (OS.DLGC_STATIC);
//}

}
